#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll x, h;
} Jarbol;

int cmp(const void *a, const void *b) {
    Jarbol *p = (Jarbol*)a;
    Jarbol *q = (Jarbol*)b;
    if (p->x < q->x) return -1;
    if (p->x > q->x) return 1;
    return 0;
}

ll absll(ll x) { return x < 0 ? -x : x; }

int main() {
    int n;
    scanf("%d", &n);

    Jarbol *a = malloc(n * sizeof(Jarbol));
    for (int i = 0; i < n; i++) scanf("%lld", &a[i].x);
    for (int i = 0; i < n; i++) scanf("%lld", &a[i].h);

    qsort(a, n, sizeof(Jarbol), cmp);

    for (int i = 0; i < n; i++) {
        ll best = -1;
        ll H = a[i].h;

        /* levi kanap */
        if (i > 0) {
            ll x1 = a[i-1].x, h1 = a[i-1].h;
            if (H <= h1) {
                ll x_hit = x1 + (h1 - H);
                ll d = absll(x_hit - a[i].x);
                best = d;
            }
        }

        /* desni kanap */
        if (i + 1 < n) {
            ll x2 = a[i+1].x, h2 = a[i+1].h;
            if (H <= h2) {
                ll x_hit = x2 - (h2 - H);
                ll d = absll(x_hit - a[i].x);
                if (best == -1 || d < best) best = d;
            }
        }

        if (best == -1) printf("-1\n");
        else printf("%lld\n", best);
    }

    free(a);
    return 0;
}